%% N2 + Ar, 1 bar + 6bar, scan YAG
% PB_TESTING2511y14
% Tvalve = -140 deg C

close all
clear all

defaultfolder = pwd;

 str = 'N2Ar_400mps_m1_15musincpl_50mus';
% str = 'N2Ar_400mps_m1_15musincpl_50mus_2';
% str = 'N2Ar_400mps_m1_15musincpl_50mus_3';
% str = 'N2Ar_400mps_m1_15musincpl_50mus_4';
% str = 'N2Ar_400mps_m1_15musincpl_50mus_5';
str1 = strcat(str,'.mat');
str2 = strcat(str,'.txt');

cd('50mus')

% load file, use "raw" data (no baseline correction):
load(str1)

YAGdelay = expparams.YAGdelay; % YAG delay (in mus)
egundelay = expparams.egundelay; % e-gun delay (in mus)

step = expparams.resolutionscan;
scanwidth = expparams.scanwidth; % range (in mus)
scanrange = (YAGdelay-egundelay)+(0:step:scanwidth)';


%% MCP signal (Neville amplifier)
%

blstart = 2.9;
blend = 3.04;
sstart = 3.041;
send = 3.056;

xdatas = xuc;

r1 = find(xdatas >= blstart,1,'first');
r2 = find(xdatas >= blend,1,'first');
r1r2 = r1:r2;

v1 = find(xdatas >= sstart,1,'first');
v2 = find(xdatas >= send,1,'first');


% signal:
ydatas = -yuc;

ydatasc = zeros(size(ydatas));
for o = 1:size(ydatas,1)
    offs = mean(ydatas(o,r1r2)); % offset
	ydatasc(o,:) = ydatas(o,:) - offs;
end

figure(1)
for o = 1:size(ydatasc,1)
    plot(xdatas,ydatasc(o,:)','k-','LineWidth',1.0)
    hold on
	plot(xdatas(v1:v2),ydatasc(o,v1:v2)','r-','LineWidth',1.0)
end
hold off
xlabel('Ion TOF (\mus)','FontSize',16)
ylabel('Signal (arb.)','FontSize',16)
set(gca,'FontSize',16)
axis([xdatas(1) xdatas(end) -3 60])

TOF = sum(ydatasc(:,v1:v2),2);


% if a reference scan exists:
if exist('yuc_ref','var') == 1
    
% reference

ydatar = -yuc_ref;

ydatarc = zeros(size(ydatar));
for o = 1:size(ydatar,1)
    offs = mean(ydatar(o,r1r2)); % offset
	ydatarc(o,:) = ydatar(o,:) - offs;
end

figure(2)
for o = 1:size(ydatarc,1)
    plot(xdatas,ydatarc(o,:)','k-','LineWidth',1.0)
    hold on
	plot(xdatas(v1:v2),ydatarc(o,v1:v2)','r-','LineWidth',1.0)
end
hold off
xlabel('Ion TOF (\mus)','FontSize',16)
ylabel('Signal (arb.)','FontSize',16)
set(gca,'FontSize',16)
axis([xdatas(1) xdatas(end) -3 60])

TOF_ref = sum(ydatarc(:,v1:v2),2);

end

%% TOF
%

figure3 = figure(3);
plot(scanrange(1:end),TOF(1:end),'r-','LineWidth',1.5)
hold on
if exist('yuc_ref','var') == 1
    plot(scanrange(1:end),TOF_ref(1:end),'k-','LineWidth',1.5)
end
hold off
xlabel('TOF (\mus)','FontSize',16)
ylabel('Signal (arb.)','FontSize',16)
axis([scanrange(1) scanrange(end) -10 400])
set(gca,'FontSize',16)
box on
pbaspect([1.7 1 1])

if exist('yuc_ref','var') == 1
    trace = [scanrange TOF TOF_ref];
else
    trace = [scanrange TOF];
end

dlmwrite(str2, trace, 'delimiter', '\t','precision', 12)

print(figure3,'-depsc',str,'-r1000')
% print(figure3,'-djpeg',str,'-r300')

cd(defaultfolder)
